@extends('user')

@section('content')


<!-- domain begin-->
<div class="domain" id="head_domain" style="padding-top:250px;padding-bottom:120px;">
    <div class="container">
        <div class="row ">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <table class="table table-striped text-center">
                            <tbody>
                            <tr>
                                <td> @lang('Withdraw TRX') </td>
                                <td>{{ $withdraw->trx }}</td>
                            </tr>
                            <tr>
                                <td> @lang('Current Balance') </td>
                                <td>{{ Auth::user()->balance}} {{ $basic->currency }}</td>
                            </tr>
                            <tr>
                                <td> @lang('Withdraw Amount') </td>
                                <td>{{ $withdraw->withdraw_amount }} {{  $basic->currency}} </td>
                            </tr>
                            <tr>
                                <td> @lang('Remaining Balance') </td>
                                <td>{{ number_format((Auth::user()->balance - $withdraw->withdraw_amount), $basic->decimal) }} {{  $basic->currency }} </td>
                            </tr>
                            <tr>
                                <td> @lang('Receive Amount') </td>
                                <td><strong>{{ $withdraw['receive_currency_amount'] }} {{  $withdraw->method->name }} </strong></td>
                            </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="card mt-4">
                    <div class="card-body">


                        <form action="{{ route('withdraw.confirm') }}" method="post">
                            <div class="col-md-12">

                                <div class="row ">
                                    @csrf
                                    <h2 class="mb-4">@lang('Additional Information')</h2>

                                    <div class="col-xl-12 col-lg-12">
                                        @include('errors.error')
                                    </div>

                                    <div class="col-xl-12 col-lg-12">
                                        <div class="form-group">
                                            <label for="email"><strong> @lang('Your Email') </strong></label>
                                            <input type="email" name="user_email" value="{{Auth::user()->email}}" class="form-control form-control-lg" placeholder="@lang('Your Email')">
                                        </div>
                                    </div>

                                    <div class="col-xl-12 col-lg-12">
                                        <div class="form-group">
                                            <label><strong> {{$withdraw->method->name}} @lang('Account')</strong></label>
                                            <input type="text" class="form-control form-control-lg" name="receive_wallet_info">
                                        </div>
                                    </div>

                                    <div class="col-md-5 text-center mt-2">
                                        <a href="{{route('home')}}"  class="btn btn-danger btn-lg"> <i class="fa fa-times"></i> @lang('Cancel Withdraw') </a>
                                    </div>

                                    <div class="col-md-6 text-center mt-2">
                                        <button type="submit" class="btn btn-info btn-lg"> <i class="fa fa-check"></i> @lang('Confirm Withdraw') </button>
                                    </div>

                                </div>

                            </div>
                        </form>

                    </div>
                </div>

            </div>

        </div>
    </div>
</div>
<!-- domain end -->

@endsection
